/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.dynamicjava;

import com.google.common.collect.Lists;
import cz.insophy.inplan.util.FileUtils;
import cz.insophy.inplan.util.dynamicjava.FileSet;
import cz.insophy.inplan.util.dynamicjava.RootDefinition;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicJavaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicJavaUtils.class);

    private DynamicJavaUtils() {
    }

    public static URLClassLoader createClassLoader(Path compiledClassesDir, ClassLoader parent) {
        URLClassLoader classLoader;
        try {
            classLoader = new URLClassLoader(new URL[]{compiledClassesDir.toUri().toURL()}, parent);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        System.gc();
        return classLoader;
    }

    public static Path createClassPathRoot(@Nullable Path buildDir, @Nullable String prefix) throws IOException {
        Path dir;
        if (buildDir == null) {
            dir = Files.createTempDirectory(prefix, new FileAttribute[0]);
        } else {
            Files.createDirectories(buildDir, new FileAttribute[0]);
            dir = Files.createTempDirectory(buildDir, prefix, new FileAttribute[0]);
        }
        return dir;
    }

    public static <T> Object constructClass(Class<?> c, Class<T> constructorArgumentType, T constructorArgument) throws IllegalStateException, RuntimeException {
        Object o;
        block6: {
            Constructor<?>[] ctors = c.getConstructors();
            Constructor<?> ctorWithParameter = null;
            Constructor<?> ctorWithoutParameters = null;
            for (Constructor<?> ctor : ctors) {
                Class<?>[] parameterTypes = ctor.getParameterTypes();
                if (parameterTypes.length == 0) {
                    ctorWithoutParameters = ctor;
                    continue;
                }
                if (!constructorArgumentType.isAssignableFrom(parameterTypes[0])) continue;
                ctorWithParameter = ctor;
            }
            try {
                if (ctorWithParameter != null) {
                    o = ctorWithParameter.newInstance(constructorArgument);
                    break block6;
                }
                if (ctorWithoutParameters != null) {
                    o = ctorWithoutParameters.newInstance(new Object[0]);
                    break block6;
                }
                throw new IllegalStateException("No viable constructor found, expected constructor with a parameter of type " + constructorArgumentType.getCanonicalName() + " or parameter-less constructor.");
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("Cannot create an instance of the given class.", e);
            }
        }
        return o;
    }

    public static void runClass(Object o) throws UnsupportedOperationException, DynamicJavaExecutionException {
        if (o instanceof Callable) {
            Callable callable = (Callable)o;
            try {
                callable.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DynamicJavaExecutionException(e);
            }
        } else {
            throw new UnsupportedOperationException("Class " + o.getClass().getCanonicalName() + " is not an instance of java.util.concurrent.Callable.");
        }
    }

    public static List<RootDefinition> parseRoots(List<FileSet> roots) {
        ArrayList<RootDefinition> res = Lists.newArrayList();
        FileSystem fsys = FileSystems.getDefault();
        for (FileSet fs : roots) {
            RootDefinition ifs = fs.toRootDefinition(fsys);
            res.add(ifs);
        }
        return res;
    }

    public static void walkRoots(@Nonnull List<RootDefinition> rootsFiles, final Consumer<PathInRoot> processPreDir, final Consumer<PathInRoot> processFile) throws IOException {
        for (RootDefinition rd : rootsFiles) {
            final Path root = rd.getRoot();
            if (!Files.exists(root, new LinkOption[0])) continue;
            final List<PathMatcher> includes = rd.getIncludes();
            final List<PathMatcher> excludes = rd.getExcludes();
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path relativeDir = root.relativize(dir);
                    if (processPreDir != null) {
                        processPreDir.accept(new PathInRoot(root, dir, relativeDir));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relativeFile = root.relativize(file);
                    if (processFile != null && includes.stream().anyMatch(m3 -> m3.matches(relativeFile)) && excludes.stream().noneMatch(m3 -> m3.matches(relativeFile))) {
                        processFile.accept(new PathInRoot(root, file, relativeFile));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void walkRoots(@Nonnull List<RootDefinition> rootsFiles, Consumer<PathInRoot> processPreDir) throws IOException {
        DynamicJavaUtils.walkRoots(rootsFiles, processPreDir, null);
    }

    public static void delete(Path p, boolean doDelete) {
        if (!doDelete) {
            return;
        }
        LOG.debug("Deleting {}", (Object)p);
        FileUtils.deleteDirectory(p.toFile());
    }

    public static class DynamicJavaExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = -1L;

        public DynamicJavaExecutionException(Throwable cause) {
            super(cause);
        }
    }

    public static final class PathInRoot {
        public final Path root;
        public final Path path;
        public final Path pathRelativeToRoot;

        private PathInRoot(Path root, Path path, Path pathRelativeToRoot) {
            this.root = root;
            this.path = path;
            this.pathRelativeToRoot = pathRelativeToRoot;
        }
    }
}

